function out=hfuncTC(u,v,nu,rho)
% this function calculates the h function of the T Copula as
% introduced in Aas et al:"Pair - copula constructions of multiple
% dependence"
% INPUTS:
% u,v:          uniform variables
% rho:          the corr coefficient of u and v
% error checking
if max(u)>1 || min(u)<0
    error('u is uniform U(0,1)')
end
if max(v)>1 || min(v)<0
    error('v is uniform U(0,1)')
end
if nargin==3
    rankcorr=corr(u,v,'type','kendall');
    rankcorr=rankcorr(1,2);
    rho=sin(rankcorr*pi/2);
end
[R,C]=size(rho);
if C>2
    error('rho is a scalar in (-1,1) or a Tx1 column')
end
out1=tinv(u,nu)-rho.*tinv(v,nu);
out2=sqrt(((nu+tinv(v,nu).^2).*(1-rho.^2))./(nu+1));
out=tcdf(out1./out2,nu+1);